package edu.uky.ai.lp.logic;

/**
 * The superclass of any Boolean expression with multiple arguments.
 * 
 * @author Stephen G. Ware
 */
public abstract class NAryBooleanExpression extends BooleanExpression {

	/** The expression's arguments */
	public final Expression[] arguments;
	
	/**
	 * Constructs a new N-ary Boolean expression with the given arguments.
	 * 
	 * @param operator the Boolean operator used
	 * @param arguments the arguments to which the operator applies
	 */
	public NAryBooleanExpression(String operator, Expression[] arguments) {
		super(operator, arguments);
		this.arguments = arguments;
	}
}
